/**
 * EMCrossoverFactory.java
 * 
 * Modified CrossoverFactory which includes new EMscheduling problem related operators.
 * Based on CrossoverFactory from jMetal.
 *
 * @author Juanjo Durillo
 * @author Mateusz Guzek
 * @version 1.0
 */

package greenmetal.base.operator.crossover;

import java.util.Properties;

import jmetal.base.operator.crossover.Crossover;
import jmetal.base.operator.crossover.DifferentialEvolutionCrossover;
import jmetal.base.operator.crossover.HUXCrossover;
import jmetal.base.operator.crossover.PMXCrossover;
import jmetal.base.operator.crossover.SBXCrossover;
import jmetal.base.operator.crossover.SinglePointCrossover;
import jmetal.base.operator.crossover.TwoPointsCrossover;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PropUtils;

/**
 * Class implementing a crossover factory.
 */
public class EMCrossoverFactory {
    
  /**
   * Gets a crossover operator through its name.
   * @param name Name of the operator
   * @return The operator
   */
  public static Crossover getCrossoverOperator(String name) throws JMException {
    if (name.equalsIgnoreCase("SBXCrossover"))
      return new SBXCrossover();
    else if (name.equalsIgnoreCase("SinglePointCrossover"))
        return new SinglePointCrossover();
    else if (name.equalsIgnoreCase("SinglePointHalfCrossover"))
        return new SinglePointHalfCrossover();
    else if (name.equalsIgnoreCase("UniformHalfCrossover"))
        return new UniformHalfCrossover();
    else if (name.equalsIgnoreCase("TwoPointHalfCrossover"))
        return new TwoPointHalfCrossover();
    else if (name.equalsIgnoreCase("EMSinglePointHalfCrossover"))
        return new SinglePointHalfCrossover();
    else if (name.equalsIgnoreCase("GroupSinglePointHalfCrossover"))
        return new GroupSinglePointHalfCrossover();
    else if (name.equalsIgnoreCase("PMXCrossover"))
      return new PMXCrossover();
    else if (name.equalsIgnoreCase("TwoPointsCrossover"))
      return new TwoPointsCrossover();
    else if (name.equalsIgnoreCase("HUXCrossover"))
      return new HUXCrossover();
    else if (name.equalsIgnoreCase("DifferentialEvolutionCrossover"))
      return new DifferentialEvolutionCrossover();
    else {
      Configuration.logger_.severe("CrossoverFactory.getCrossoverOperator. " +
          "Operator '" + name + "' not found ");
      throw new JMException("Exception in " + name + ".getCrossoverOperator()") ;
    } // else        
  } // getCrossoverOperator


  /**
   * Gets a crossover operator through its name.
   * @param name Name of the operator
   * @return The operator
   */
  public static Crossover getCrossoverOperator(String name, Properties properties) throws JMException {
    if (name.equalsIgnoreCase("SBXCrossover"))
      return new SBXCrossover(PropUtils.getPropertiesWithPrefix(properties, name+"."));
    else if (name.equalsIgnoreCase("SinglePointCrossover"))
        return new SinglePointCrossover(PropUtils.getPropertiesWithPrefix(properties, name+"."));
    else if (name.equalsIgnoreCase("SinglePointHalfCrossover"))
        return new SinglePointHalfCrossover(PropUtils.getPropertiesWithPrefix(properties, name+"."));
    else if (name.equalsIgnoreCase("UniformHalfCrossover"))
        return new UniformHalfCrossover(PropUtils.getPropertiesWithPrefix(properties, name+"."));
    else if (name.equalsIgnoreCase("TwoPointHalfCrossover"))
        return new TwoPointHalfCrossover(PropUtils.getPropertiesWithPrefix(properties, name+"."));
    else if (name.equalsIgnoreCase("EMSinglePointHalfCrossover"))
        return new SinglePointHalfCrossover(PropUtils.getPropertiesWithPrefix(properties, name+"."));
    else if (name.equalsIgnoreCase("GroupSinglePointHalfCrossover"))
        return new GroupSinglePointHalfCrossover(PropUtils.getPropertiesWithPrefix(properties, name+"."));
    else if (name.equalsIgnoreCase("PMXCrossover"))
      return new PMXCrossover(PropUtils.getPropertiesWithPrefix(properties, name+"."));
    else if (name.equalsIgnoreCase("TwoPointsCrossover"))
      return new TwoPointsCrossover(PropUtils.getPropertiesWithPrefix(properties, name+"."));
    else if (name.equalsIgnoreCase("HUXCrossover"))
      return new HUXCrossover(PropUtils.getPropertiesWithPrefix(properties, name+"."));
    else if (name.equalsIgnoreCase("DifferentialEvolutionCrossover"))
      return new DifferentialEvolutionCrossover(PropUtils.getPropertiesWithPrefix(properties, name+"."));
    else {
      Configuration.logger_.severe("CrossoverFactory.getCrossoverOperator. " +
          "Operator '" + name + "' not found ");
      throw new JMException("Exception in " + name + ".getCrossoverOperator()") ;
    } // else
  } // getCrossoverOperator

} // CrossoverFactory
