/**
 * GroupSinglePointHalfCrossover.java
 * 
 * Class representing grouping crossover with single point crossover application.
 * The other half is treated as voltage levels and copied together with
 * corresponding assignments of the first part.
 * 
 * @author Mateusz Guzek
 * @version 1.0
 */
package greenmetal.base.operator.crossover;

import java.util.Properties;
import jmetal.base.*;
import jmetal.base.operator.crossover.Crossover;
import jmetal.base.variable.*;
import jmetal.base.*;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.Configuration.*;

/**
 * This class allows to apply a Single Point crossover operator using two parent
 * solutions.
 * NOTE: the operator is applied to integer solutions, considering first
 * half of the solution as a crossover eligible solution part.
 * @author Mateusz Guzek
 */
public class GroupSinglePointHalfCrossover extends Crossover {

	/**
	 * INT_SOLUTION represents class jmetal.base.solutionType.IntSolutionType
	 */
	private static Class INT_SOLUTION ; 

	/**
	 * Constructor
	 * Creates a new instance of the single point crossover operator
	 */
	public GroupSinglePointHalfCrossover() {
		System.out.println("Grouping EMcrossover initialized");
		try {
			INT_SOLUTION = Class.forName("jmetal.base.solutionType.IntSolutionType") ;
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} // catch
	} // SinglePointCrossover


	/**
	 * Constructor
	 * Creates a new instance of the single point crossover operator
	 */
	public GroupSinglePointHalfCrossover(Properties properties) {
		this();
	} // SinglePointCrossover

	/**
	 * Perform the crossover operation.
	 * @param probability Crossover probability
	 * @param parent1 The first parent
	 * @param parent2 The second parent
	 * @return An array containig the two offsprings
	 * @throws JMException
	 */
	public Solution[] doCrossover(double probability,
			Solution parent1,
			Solution parent2) throws JMException {
		Solution[] offSpring = new Solution[2];
		offSpring[0] = new Solution(parent1);
		offSpring[1] = new Solution(parent2);
		try {
			if (PseudoRandom.randDouble() < probability) {
				// Integer representation
				int valueX1;
				int valueX2;
				int valueY1;
				int valueY2;
				//if(PseudoRandom.randDouble() < 0.5){
					//Crossover first variable
					int crossoverPoint1;
					int crossoverPoint2;
					//= PseudoRandom.randInt(0, parent1.numberOfVariables()/2 - 1);
					int[] auxg1, auxg2;
					int acount1 = 0, acount2 = 0;
					int[] group1, group2;
					auxg1 = new int[(int)parent1.getDecisionVariables()[0].getUpperBound()+1];
					auxg2 = new int[(int)parent2.getDecisionVariables()[0].getUpperBound()+1];
					
					for(int i = 0; i< auxg1.length;i++){
						auxg1[i]=-1;
					}
					for(int i = 0; i< auxg2.length;i++){
						auxg2[i]=-1;
					}
					/*Create group part*/
					for(int i = 0; i< parent1.numberOfVariables()/2;i++){
						if(auxg1[(int)parent1.getDecisionVariables()[i].getValue()]==-1){
						auxg1[(int)parent1.getDecisionVariables()[i].getValue()]=(int)parent1.getDecisionVariables()[i].getValue();
						acount1++;
						}
					}
					for(int i = 0; i< parent2.numberOfVariables()/2;i++){
						if(auxg2[(int)parent2.getDecisionVariables()[i].getValue()]==-1){
						auxg2[(int)parent2.getDecisionVariables()[i].getValue()]=(int)parent2.getDecisionVariables()[i].getValue();
						acount2++;
						}
					}
					group1 = new int[acount1];
					group2 = new int[acount2];
					for(int i = 0, j=0; i < auxg1.length;i++){
						if(auxg1[i]!=-1){
							group1[j]=auxg1[i];
							j++;
						}
					}
					for(int i = 0, j=0; i < auxg2.length;i++){
						if(auxg2[i]!=-1){
							group2[j]=auxg2[i];
							j++;
						}
					}
					int random_index;
					int tmp_value;
					/*Permute group part*/
					for(int i = 0; i < group1.length; i++){
						random_index = PseudoRandom.randInt(i, group1.length-1);
						tmp_value = group1[i];
						group1[i]=group1[random_index];
						group1[random_index]=tmp_value;
					}
					for(int i = 0; i < group2.length; i++){
						random_index = PseudoRandom.randInt(i, group2.length-1);
						tmp_value = group2[i];
						group2[i]=group2[random_index];
						group2[random_index]=tmp_value;
					}
					crossoverPoint1 = PseudoRandom.randInt(0, group1.length-1);
					crossoverPoint2 = PseudoRandom.randInt(0, group2.length-1);
					/*DEBUG*/
//					System.out.println("Variables parent 1:");
//					for (int i = 0; i < parent1.numberOfVariables()/2; i++){
//						System.out.print((int)parent1.getDecisionVariables()[i].getValue()+" ");
//					}System.out.println("");
//					System.out.println("Group parent1:");
//					for (int i = 0; i < group1.length; i++){
//						System.out.print(group1[i]+" ");
//					}System.out.println("");
//					System.out.println("Variables parent 2:");
//					for (int i = 0; i < parent2.numberOfVariables()/2; i++){
//						System.out.print((int)parent2.getDecisionVariables()[i].getValue()+" ");
//					}System.out.println("");
//					System.out.println("Group parent2:");
//					for (int i = 0; i < group2.length; i++){
//						System.out.print(group2[i]+" ");
//					}System.out.println("");
//					System.out.println("Cross1:"+crossoverPoint1);
//					System.out.println("Cross2:"+crossoverPoint2);
					/*DEBUG END*/
					/*Create a temporary copy of parent1 processors part*/
					int p1_temp[] = new int[parent1.numberOfVariables()/2];		
					for (int i = crossoverPoint1; i < parent1.numberOfVariables()/2; i++){
						p1_temp[i]=(int) parent1.getDecisionVariables()[i].getValue();
					}
					/*Main Crossover part*/
					for(int k = crossoverPoint2; k < group2.length;k++){
					for (int i = 0; i < parent2.numberOfVariables()/2; i++) {
						if(((int)parent2.getDecisionVariables()[i].getValue())==group2[k]){
							offSpring[0].getDecisionVariables()[i].setValue
								(parent2.getDecisionVariables()[i].getValue());
							offSpring[0].getDecisionVariables()[i+parent2.numberOfVariables()/2].setValue
							(parent2.getDecisionVariables()[i+parent2.numberOfVariables()/2].getValue());
						}
					}
					}// for
					for(int k = crossoverPoint1; k < group1.length;k++){
						for (int i = 0; i < parent1.numberOfVariables()/2; i++) {
							if(((int)parent1.getDecisionVariables()[i].getValue())==group1[k]){
								offSpring[1].getDecisionVariables()[i].setValue
									(parent1.getDecisionVariables()[i].getValue());
								offSpring[1].getDecisionVariables()[i+parent1.numberOfVariables()/2].setValue
								(parent1.getDecisionVariables()[i+parent1.numberOfVariables()/2].getValue());
							}
						}
						}// for

					/*DEBUG*/
//					System.out.println("Variables offspring 0:");
//					for (int i = 0; i < offSpring[0].numberOfVariables()/2; i++){
//						System.out.print((int)offSpring[0].getDecisionVariables()[i].getValue()+" ");
//					}
//					System.out.println("");
//					System.out.println("Variables offspring 1:");
//					for (int i = 0; i < offSpring[1].numberOfVariables()/2; i++){
//						System.out.print((int)offSpring[1].getDecisionVariables()[i].getValue()+" ");
//					}
//					System.out.println("");
					/*DEBUG END*/
			}
		} catch (ClassCastException e1) {
			Configuration.logger_.severe("SinglePointCrossover.doCrossover: Cannot perfom " +
			"SinglePointCrossover");
			Class cls = java.lang.String.class;
			String name = cls.getName();
			throw new JMException("Exception in " + name + ".doCrossover()");
		}
		return offSpring;
	} // doCrossover

	/**
	 * Executes the operation
	 * @param object An object containing an array of two solutions
	 * @return An object containing an array with the offSprings
	 * @throws JMException
	 */
	public Object execute(Object object) throws JMException {
		Solution[] parents = (Solution[]) object;

		if (((parents[0].getType().getClass() != INT_SOLUTION) ||
								(parents[1].getType().getClass() != INT_SOLUTION))) {

			Configuration.logger_.severe("SinglePointCrossover.execute: the solutions " +
					"are not of the right type. The type should be 'Binary' or 'Int', but " +
					parents[0].getType() + " and " +
					parents[1].getType() + " are obtained");

			Class cls = java.lang.String.class;
			String name = cls.getName();
			throw new JMException("Exception in " + name + ".execute()");
		} // if

		Double probability = (Double) getParameter("probability");
		if (parents.length < 2) {
			Configuration.logger_.severe("SinglePointCrossover.execute: operator " +
			"needs two parents");
			Class cls = java.lang.String.class;
			String name = cls.getName();
			throw new JMException("Exception in " + name + ".execute()");
		} else if (probability == null) {
			Configuration.logger_.severe("SinglePointCrossover.execute: probability " +
			"not specified");
			Class cls = java.lang.String.class;
			String name = cls.getName();
			throw new JMException("Exception in " + name + ".execute()");
		}

		Solution[] offSpring;
		offSpring = doCrossover(probability.doubleValue(),
				parents[0],
				parents[1]);

		//-> Update the offSpring solutions
		for (int i = 0; i < offSpring.length; i++) {
			offSpring[i].setCrowdingDistance(0.0);
			offSpring[i].setRank(0);
		}
		return offSpring;//*/
	} // execute
} // SinglePointCrossover
