/**
 * EMExperiment.java
 * 
 * Class extending ExperimentNoPareto and performing standard test run of algorithms
 * with standard settings. 
 * 
 * The test directory should have exactly the same name as the instance,
 * which should be inside this directory. Remember about file_proc with processors specifications inside this
 * directory. (requirement of EMscheduling problem).
 * 
 * @author Mateusz Guzek
 * @version 1.0
 */

package greenmetal.experiments;

import greenmetal.experiments.settings.IBEA_Settings;
import greenmetal.experiments.settings.MOCell_Settings;
import greenmetal.experiments.settings.NSGAII_Settings;
import greenmetal.experiments.settings.AbYSS_Settings;
import greenmetal.experiments.util.GeneratePareto;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import jmetal.base.Algorithm;
import jmetal.base.Problem;
import greenmetal.experiments.Settings;
import jmetal.experiments.settings.RandomSearch_Settings;
import jmetal.util.Configuration;
import jmetal.util.JMException;

public class EMExperiment extends ExperimentNoPareto {
public static int  independentRuns = 50;
	@Override
	public void algorithmSettings(Problem problem, int problemIndex,
			Algorithm[] algorithm) {
		try {
			int numberOfAlgorithms = algorithmNameList_.length;

			Properties[] parameters = new Properties[numberOfAlgorithms];

			for (int i = 0; i < numberOfAlgorithms; i++) {
				parameters[i] = new Properties();
				parameters[i].setProperty("crossover_", "GroupSinglePointHalfCrossover");
			} // for
//			for (int i = 0; i < numberOfAlgorithms; i++) {
//				double value = ((double)1) - i*0.1;
//				parameters[i].setProperty("crossoverProbability_", ""+value);
////				parameters[i].setProperty("crossoverProbability_", "0.85");
////				parameters[i].setProperty("reclaim_", "true");
//			}
			
			//I guess this one is not needed in no pareto case:
//			if ((!paretoFrontFile_[problemIndex].equals("")) || 
//					(paretoFrontFile_[problemIndex] == null)) {
//				for (int i = 0; i < numberOfAlgorithms; i++)
//					parameters[i].setProperty("paretoFrontFile_", 
//							paretoFrontFile_[problemIndex]);
//			} // if
			
			//Identify algo by name. MOCell by default.
			for (int i = 0; i < numberOfAlgorithms; i++){
				
				if(algorithmNameList_[i].startsWith("NSGAII")){
				algorithm[i] = new NSGAII_Settings(problem).configure(parameters[i]);
			} else if(algorithmNameList_[i].startsWith("IBEA")){
				algorithm[i] = new IBEA_Settings(problem).configure(parameters[i]);
			} else if(algorithmNameList_[i].startsWith("AbYSS")){
				algorithm[i] = new AbYSS_Settings(problem).configure(parameters[i]);
			} else if(algorithmNameList_[i].startsWith("Random")){
				algorithm[i] = new RandomSearch_Settings(problem).configure(/*parameters[i]*/);
			}
			else {
				algorithm[i] = new MOCell_Settings(problem).configure(parameters[i]);
			}
			}

		} catch (IllegalArgumentException ex) {
			Logger.getLogger(EMExperiment.class.getName()).log(Level.SEVERE, null, ex);
		} catch (IllegalAccessException ex) {
			Logger.getLogger(EMExperiment.class.getName()).log(Level.SEVERE, null, ex);
		} catch (JMException ex) {
			Logger.getLogger(EMExperiment.class.getName()).log(Level.SEVERE, null, ex);
		} 
		catch (ClassNotFoundException ex) {
			Logger.getLogger(EMExperiment.class.getName()).log(Level.SEVERE, null, ex);
		}

	}

	public static void main(String[] args) throws JMException, IOException{
		//Creation of experiment and setting its name
		EMExperiment exp = new EMExperiment();
		
		if(args.length>0){
		String exp_name = args[0];
		exp.experimentName_ = exp_name;}
		else {
			exp.experimentName_ ="TestEMschedulingStudy";
		}
		String alg_name;
		if(args.length>1){
			alg_name = args[1];
		} else {
			alg_name = "MOCell";
		}

		//Setting algorithms, problems and indicators:
		exp.algorithmNameList_ = new String[] {"MOCell", "NSGAII","IBEA"};//,"AbYSS"
//		exp.algorithmNameList_ = new String[] {alg_name+"1.0",alg_name+"0.9",alg_name+"0.8",alg_name+"0.7",alg_name+"0.6",alg_name+"0.5"/*,"RandomSearch"*/};
		//exp.problemList_ = new String[] {"EMscheduling"};
//		exp.paretoFrontFile_ = new String[] {"EMscheduling.pf"};
		exp.indicatorList_   = new String[] {"HV", "SPREAD", "IGD", "EPSILON"} ;

		if(args.length>0){
		//String base = new File(".").getAbsolutePath();
		//String base = System.getProperty("user.dir");
		String base = ".";
			System.out.println(base);
		exp.experimentBaseDirectory_ = base+ "/" + exp.experimentName_;
		exp.paretoFrontDirectory_ = base+"/" + exp.experimentName_+"/paretoFronts/";}

		else {
		exp.experimentBaseDirectory_ = "/home/mateusz/programming/test/" + exp.experimentName_;
		exp.paretoFrontDirectory_ = "/home/mateusz/programming/test/"+ exp.experimentName_+"/paretoFronts/";}

		
		File dir = new File(exp.experimentBaseDirectory_);
		String[] instances = dir.list();
		LinkedList<String> tmp_instaces = new LinkedList<String>(); 
		for(int i = 0; i < instances.length; i++){
			if(instances[i].endsWith(".dag")){
				tmp_instaces.add(instances[i]);
			}
		}
		instances = new String[tmp_instaces.size()];
		for(int i = 0; i < instances.length; i++){
			instances[i]=tmp_instaces.remove(0);
		}
		tmp_instaces.clear();
		if(instances.length==0){
			System.err.println("No files in: "+ exp.experimentBaseDirectory_);
		} else {
			System.out.println("Instances used for simulations:");
			for(int i = 0; i < instances.length; i++){
				System.out.println(instances[i]);
			}
		}
		exp.problemList_ = instances;
		exp.paretoFrontFile_ = new String[exp.problemList_.length];
		for(int i = 0; i < exp.paretoFrontFile_.length ;i++){
			exp.paretoFrontFile_[i] = instances[i]+".pf";
		}
		
		
		exp.timmingFileName_ = "TIMMINGS";
		
		int numberOfAlgorithms = exp.algorithmNameList_.length;
		exp.algorithmSettings_ = new Settings[numberOfAlgorithms];

		exp.independentRuns_ = independentRuns;
		
		exp.params_ = new Object[5];
/*name of instance/problem file (params_[0]) is changed internally in runExperimentNoPareto and GeneratePareto
 * which looks as follows: */
//		if(exp.instances_.length>1){
//			exp.params_[0] = exp.experimentBaseDirectory_+"/"+exp.instances_[inst];}
//			else {
//				exp.params_[0] = exp.experimentBaseDirectory_+"/"+exp.problemList_[problemId];
//			}
		exp.params_[1] = exp.experimentBaseDirectory_+"/"+"file_proc";
		exp.params_[2] = true;
		exp.params_[3] = Configuration.logger_;
		exp.params_[4] = false;
		
		// Run the experiments
		int numberOfThreads ;
		exp.runExperiment(numberOfThreads = 1) ;

		
		System.out.println("Creation");
		GeneratePareto paretoFront= new GeneratePareto(exp);
		System.out.println("Running");
		paretoFront.run();
		System.out.println("Computation");
		paretoFront.computeQualityIndicators();
		
		// Generate latex tables (comment this sentence is not desired)
		exp.generateLatexTables() ;
//
		// Configure the R scripts to be generated
		int rows  ;
		int columns  ;
		String prefix ;
		String [] problems ;

		
		columns = 2 ;
		rows = 2;//java.lang.Math.max(exp.problemList_.length/columns,1) ;
		prefix = exp.experimentName_;
		//prefix = new String("Problems");
//		problems = new String[]{"EMscheduling"} ;

		boolean notch ;
		exp.generateRBoxplotScripts(rows, columns, exp.problemList_, prefix, notch = true) ;
		exp.generateRWilcoxonScripts(exp.problemList_, prefix) ;  

		//exp.generateLatexTables();
	}
}
