/**
 * IBEA_main_EMscheduling.java
 * 
 * EMscheduling class for IBEA.
 * Based on IBEA_main from jMetal.
 *
 * @author Juan J. Durillo
 * @author Mateusz Guzek
 * @version 1.0
 */
package greenmetal.metaheuristics.ibea;

import greenmetal.base.operator.crossover.*;
import greenmetal.base.operator.mutation.EMMutationFactory;
import greenmetal.problems.EMscheduling.EMscheduling;

import java.io.IOException;
import jmetal.base.*;
import jmetal.base.operator.mutation.*    ;
import jmetal.base.operator.selection.*   ;
import jmetal.metaheuristics.ibea.IBEA;
import jmetal.problems.*                  ;
import jmetal.problems.DTLZ.*;
import jmetal.problems.ZDT.*;
import jmetal.problems.WFG.*;
import jmetal.problems.LZ09.* ;
import jmetal.qualityIndicator.QualityIndicator;

import jmetal.util.Configuration;
import jmetal.util.JMException;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import jmetal.base.operator.comparator.FitnessComparator;

public class IBEA_main_EMscheduling {
  public static Logger      logger_ ;      // Logger object
  public static FileHandler fileHandler_ ; // FileHandler object

  /**
   * @param args Command line arguments.
   * @throws JMException 
   * @throws IOException 
   * @throws SecurityException 
   * Usage: three choices
   *      - jmetal.metaheuristics.nsgaII.NSGAII_main
   *      - jmetal.metaheuristics.nsgaII.NSGAII_main problemName
   *      - jmetal.metaheuristics.nsgaII.NSGAII_main problemName paretoFrontFile
   */
  public static void main(String [] args) throws JMException, IOException, ClassNotFoundException {
    Problem   problem   ;         // The problem to solve
    Algorithm algorithm ;         // The algorithm to use
    Operator  crossover ;         // Crossover operator
    Operator  mutation  ;         // Mutation operator
    Operator  selection ;         // Selection operator

    QualityIndicator indicators ; // Object to get quality indicators

    // Logger object and file to store log messages
    logger_      = Configuration.logger_ ;
    fileHandler_ = new FileHandler("IBEA.log"); 
    logger_.addHandler(fileHandler_) ;
    
    indicators = null ;
    boolean test_evaluation = false;
    problem =  new EMscheduling().initializeEMProblem(args,true, logger_, test_evaluation);
    if(problem==null){
    	logger_.severe("ERROR: No problem!");
    }

    algorithm = new IBEA(problem);

    // Algorithm parameters
    algorithm.setInputParameter("populationSize",100);
    algorithm.setInputParameter("archiveSize",100);
    algorithm.setInputParameter("maxEvaluations",3000);

    
    // Mutation and Crossover for Integer codification 
    crossover = EMCrossoverFactory.getCrossoverOperator("GroupSinglePointHalfCrossover"); 
//  crossover = EMCrossoverFactory.getCrossoverOperator("SinglePointHalfCrossover");
    crossover.setParameter("probability",0.8);                   
    crossover.setParameter("distributionIndex",20.0);//20
  
    mutation = EMMutationFactory.getMutationOperator("EMBitFlipMutation");                    
    mutation.setParameter("probability",1.0/problem.getNumberOfVariables());
 	mutation.setParameter("distributionIndex",20.0);//20

    /* Selection Operator */
    selection = new BinaryTournament(new FitnessComparator());
    // Add the operators to the algorithm
    algorithm.addOperator("crossover",crossover);
    algorithm.addOperator("mutation",mutation);
    algorithm.addOperator("selection",selection);

    // Execute the Algorithm
    long initTime = System.currentTimeMillis();
    SolutionSet population = algorithm.execute();
    long estimatedTime = System.currentTimeMillis() - initTime;

    // Print the results
    logger_.info("Total execution time: "+estimatedTime + "ms");
    logger_.info("Variables values have been writen to file VAR");
    population.printVariablesToFile("VAR");    
    logger_.info("Objectives values have been writen to file FUN");
    population.printObjectivesToFile("FUN");
  
    if (indicators != null) {
      logger_.info("Quality indicators") ;
      logger_.info("Hypervolume: " + indicators.getHypervolume(population)) ;
      logger_.info("GD         : " + indicators.getGD(population)) ;
      logger_.info("IGD        : " + indicators.getIGD(population)) ;
      logger_.info("Spread     : " + indicators.getSpread(population)) ;
      logger_.info("Epsilon    : " + indicators.getEpsilon(population)) ;  
    } // if
  } //main
} // IBEA_main.java
