/**
 * MOCellConv.java
 * 
 * Convergence check class for MOCell.
 * Based on MOCell from jMetal.
 * 
 * @author Juan J. Durillo
 * @author Mateusz Guzek
 * @version 1.0
 *
 */
package greenmetal.metaheuristics.mocell;

import greenmetal.experiments.ExperimentConvergence;
import greenmetal.metaheuristics.AlgorithmConvergence;
import jmetal.base.*;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

import jmetal.qualityIndicator.QualityIndicator;
import jmetal.util.archive.CrowdingArchive;
import jmetal.base.operator.comparator.*;
//import jmetal.experiments.ExperimentNoPareto;
import jmetal.util.*;

/** 
 * This class represents an asynchronous version of MOCell algorithm, combining
 * aMOCell2 and aMOCell3.
 */
public class MOCellConv extends Algorithm implements AlgorithmConvergence{

  //->fields
  private Problem problem_;          //The problem to solve        

  public MOCellConv(Problem problem){
    problem_ = problem;
  }
  public SolutionSet execute()
  {
	System.out.println("Error in MOCellConv: for the convergence study, the method execute with no parameters cannot be called");
	return null;
  }
  /** Execute the algorithm 
   * @throws JMException */
  public SolutionSet execute(double [][][][][] metrics,int problemID, int inst, int alg,String[] indicatorList, String paretoFrontFile, String experimentDirectory) throws JMException, ClassNotFoundException {
    //Init the parameters
    int populationSize, archiveSize, maxEvaluations, evaluations;
    Operator mutationOperator, crossoverOperator, selectionOperator;
    SolutionSet currentPopulation;
    CrowdingArchive archive;
    SolutionSet [] neighbors;    
    Neighborhood neighborhood;
    Comparator dominance = new DominanceComparator();  
    Comparator crowdingComparator = new CrowdingComparator();
    Distance distance = new Distance();

    // Read the parameters
    populationSize    = ((Integer)getInputParameter("populationSize")).intValue();
    archiveSize       = ((Integer)getInputParameter("archiveSize")).intValue();
    maxEvaluations    = ((Integer)getInputParameter("maxEvaluations")).intValue();                                

    // Read the operators
    mutationOperator  = operators_.get("mutation");
    crossoverOperator = operators_.get("crossover");
    selectionOperator = operators_.get("selection");        

    // Initialize the variables    
    currentPopulation  = new SolutionSet(populationSize);        
    archive            = new CrowdingArchive(archiveSize,problem_.getNumberOfObjectives());                
    evaluations        = 0;                        
    neighborhood       = new Neighborhood(populationSize);
    neighbors          = new SolutionSet[populationSize];

    // Create the initial population
    for (int i = 0; i < populationSize; i++){
      Solution individual = new Solution(problem_);
      problem_.evaluate(individual);           
      problem_.evaluateConstraints(individual);
      currentPopulation.add(individual);
      individual.setLocation(i);
      evaluations++;
    }
    
	QualityIndicator indicators = null;
	if (indicatorList.length > 0) {
		// System.out.println("PF file: " +
		// paretoFrontFile_[problemId]);
		indicators = new QualityIndicator(problem_,
				paretoFrontFile);
	}
	int generations = 0;

    // Main loop
    while (evaluations < maxEvaluations){                                 
      for (int ind = 0; ind < currentPopulation.size(); ind++){
        Solution individual = new Solution(currentPopulation.get(ind));

        Solution [] parents = new Solution[2];
        Solution [] offSpring;

        //neighbors[ind] = neighborhood.getFourNeighbors(currentPopulation,ind);
        neighbors[ind] = neighborhood.getEightNeighbors(currentPopulation,ind);                                                           
        neighbors[ind].add(individual);

        // parents
        parents[0] = (Solution)selectionOperator.execute(neighbors[ind]);
        if (archive.size() > 0) {
          parents[1] = (Solution)selectionOperator.execute(archive);
        } else {                   
          parents[1] = (Solution)selectionOperator.execute(neighbors[ind]);
        }

        // Create a new individual, using genetic operators mutation and crossover
        offSpring = (Solution [])crossoverOperator.execute(parents);               
        mutationOperator.execute(offSpring[0]);

        // Evaluate individual an his constraints
        problem_.evaluate(offSpring[0]);
        problem_.evaluateConstraints(offSpring[0]);
        evaluations++;

        int flag = dominance.compare(individual,offSpring[0]);

        if (flag == 1) { //The new individual dominates
          offSpring[0].setLocation(individual.getLocation());                                      
          currentPopulation.replace(offSpring[0].getLocation(),offSpring[0]);
          archive.add(new Solution(offSpring[0]));                   
        } else if (flag == 0) { //The new individual is non-dominated               
          neighbors[ind].add(offSpring[0]);               
          offSpring[0].setLocation(-1);
          Ranking rank = new Ranking(neighbors[ind]);
          for (int j = 0; j < rank.getNumberOfSubfronts(); j++) {
            distance.crowdingDistanceAssignment(rank.getSubfront(j),
                                                problem_.getNumberOfObjectives());
          }
          neighbors[ind].sort(crowdingComparator); 
          Solution worst = neighbors[ind].get(neighbors[ind].size()-1);

          if (worst.getLocation() == -1) { //The worst is the offspring
            archive.add(new Solution(offSpring[0]));
          } else {
            offSpring[0].setLocation(worst.getLocation());
            currentPopulation.replace(offSpring[0].getLocation(),offSpring[0]);
            archive.add(new Solution(offSpring[0]));
          }                                          
        }
      }   
      // NEW STEP FOR THE CONVERGENCE STUDY: for calculating the convergence speed of the front in terms of the quality indicators
      if (indicatorList.length > 0) {
//			QualityIndicator indicators;
//			// System.out.println("PF file: " +
//			// paretoFrontFile_[problemId]);
//			indicators = new QualityIndicator(problem_,
//					paretoFrontFile);

			for (int j = 0; j < indicatorList.length; j++) {
				if (indicatorList[j].equals("HV")) {
					double value = indicators.getHypervolume(archive);
					metrics[problemID][inst][alg][j][generations] = value;
				}
				if (indicatorList[j].equals("SPREAD")) {
						double value = indicators.getSpread(archive);
						metrics[problemID][inst][alg][j][generations] = value;
				}
				if (indicatorList[j].equals("IGD")) {
						double value = indicators.getIGD(archive);
						metrics[problemID][inst][alg][j][generations] = value;
				}
				if (indicatorList[j].equals("EPSILON")) {
						double value = indicators.getEpsilon(archive);
						metrics[problemID][inst][alg][j][generations] = value;
				}
			} // for
		} // if
      
      generations++;
    } // while     
	int maxgen = generations - 1;
	

	// Prints all the values in metrics in files
	if (indicatorList.length > 0) {

		for (int j = 0; j < indicatorList.length; j++) {
			if (indicatorList[j].equals("HV")) {
				FileWriter os;
				try {
					os = new FileWriter(experimentDirectory
							+ "/ConvHV", true);
					for (int gens = 0; gens < maxgen; gens++)
						os.write("" + metrics[problemID][inst][alg][j][gens] + " ");
					os.write("\n");
					os.close();
				} catch (IOException ex) {
					Logger.getLogger(
							ExperimentConvergence.class.getName())
							.log(Level.SEVERE, null, ex);
				}
			}
			if (indicatorList[j].equals("SPREAD")) {
				FileWriter os = null;
				try {
					
					os = new FileWriter(experimentDirectory
							+ "/ConvSPREAD", true);
					for (int gens = 0; gens < maxgen; gens++)
						os.write("" + metrics[problemID][inst][alg][j][gens] + " ");
					os.write("\n");
					os.close();
				} catch (IOException ex) {
					Logger.getLogger(
							ExperimentConvergence.class.getName())
							.log(Level.SEVERE, null, ex);
				} finally {
					try {
						os.close();
					} catch (IOException ex) {
						Logger.getLogger(
								ExperimentConvergence.class
								.getName()).log(
										Level.SEVERE, null, ex);
					}
				}
			}
			if (indicatorList[j].equals("IGD")) {
				FileWriter os = null;
				try {
					os = new FileWriter(experimentDirectory
							+ "/ConvIGD", true);
					for (int gens = 0; gens < maxgen; gens++)
						os.write("" + metrics[problemID][inst][alg][j][gens] + " ");
					os.write("\n");
					os.close();
				} catch (IOException ex) {
					Logger.getLogger(
							ExperimentConvergence.class.getName())
							.log(Level.SEVERE, null, ex);
				} finally {
					try {
						os.close();
					} catch (IOException ex) {
						Logger.getLogger(
								ExperimentConvergence.class
								.getName()).log(
										Level.SEVERE, null, ex);
					}
				}
			}
			if (indicatorList[j].equals("EPSILON")) {
				FileWriter os = null;
				try {
					os = new FileWriter(experimentDirectory
							+ "/ConvEPSILON", true);
					for (int gens = 0; gens < maxgen; gens++)
						os.write("" + metrics[problemID][inst][alg][j][gens] + " ");
					os.write("\n");
					os.close();
				} catch (IOException ex) {
					Logger.getLogger(
							ExperimentConvergence.class.getName())
							.log(Level.SEVERE, null, ex);
				} finally {
					try {
						os.close();
					} catch (IOException ex) {
						Logger.getLogger(
								ExperimentConvergence.class
								.getName()).log(
										Level.SEVERE, null, ex);
					}
				}
			}
		} // for
	} // if
    return archive;
  }      
} // MOCell

