/**
 * MOCell_main_EMscheduling.java
 *
 * EMscheduling class for MOCel.
 * Based on MOCell_main from jMetal.
 * 
 * @author Juan J. Durillo
 * @author Mateusz Guzek
 * @version 1.0
 * 
 * This class executes the algorithms described in
 *   A.J. Nebro, J.J. Durillo, F. Luna, B. Dorronsoro, E. Alba 
 *   "Design Issues in a Multiobjective Cellular Genetic Algorithm." 
 *   Evolutionary Multi-Criterion Optimization. 4th International Conference, 
 *   EMO 2007. Sendai/Matsushima, Japan, March 2007.
 */
package greenmetal.metaheuristics.mocell;

import greenmetal.base.operator.crossover.*;
import greenmetal.base.operator.mutation.EMMutationFactory;
import greenmetal.problems.EMscheduling.EMscheduling;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Logger;

import jmetal.base.*;
import jmetal.base.operator.mutation.*    ; 
import jmetal.base.operator.selection.*   ;
import jmetal.metaheuristics.mocell.MOCell;
import jmetal.problems.*                  ;
import jmetal.problems.DTLZ.*;

import jmetal.problems.ZDT.* ;
import jmetal.problems.WFG.* ;
import jmetal.problems.LZ09.* ;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

import java.util.logging.FileHandler;
import java.util.logging.Logger;

import jmetal.qualityIndicator.QualityIndicator;

public class MOCell_main_EMscheduling {
  public static Logger      logger_ ;      // Logger object
  public static FileHandler fileHandler_ ; // FileHandler object
  
  /**
   * @param args Command line arguments. The first (optional) argument specifies 
   *             the problem to solve.
   * @throws JMException 
   * @throws IOException 
   * @throws SecurityException 
   * Usage: three options
   *      - jmetal.metaheuristics.mocell.MOCell_main
   *      - jmetal.metaheuristics.mocell.MOCell_main problemName
   *      - jmetal.metaheuristics.mocell.MOCell_main problemName ParetoFrontFile
   */
  public static void main(String [] args) throws JMException, SecurityException, IOException, ClassNotFoundException {
    Problem   problem   ;         // The problem to solve
    Algorithm algorithm ;         // The algorithm to use
    Operator  crossover ;         // Crossover operator
    Operator  mutation  ;         // Mutation operator
    Operator  selection ;         // Selection operator

    QualityIndicator indicators ; // Object to get quality indicators

    // Logger object and file to store log messages
    logger_      = Configuration.logger_ ;
    fileHandler_ = new FileHandler("MOCell_main.log"); 
    logger_.addHandler(fileHandler_) ;
    
    indicators = null ;
    boolean test_evaluation = false;
    problem = new EMscheduling().initializeEMProblem(args,true, logger_, test_evaluation);
    if(problem==null){
    	logger_.severe("ERROR: No problem!");
    }
//    for(int i = 0; i < 100; i++){
//    	System.out.println(PseudoRandom.randInt(0,2));
//    }
    algorithm = new MOCell(problem);
 
    // Algorithm parameters
    algorithm.setInputParameter("populationSize",100);
    algorithm.setInputParameter("archiveSize",100);
    algorithm.setInputParameter("maxEvaluations",25000);
    algorithm.setInputParameter("feedBack",20);
      
    // Mutation and Crossover for Integer codification 
//    crossover = EMCrossoverFactory.getCrossoverOperator("GroupSinglePointHalfCrossover"); 
//    crossover = EMCrossoverFactory.getCrossoverOperator("SinglePointHalfCrossover");
    crossover = EMCrossoverFactory.getCrossoverOperator("TwoPointHalfCrossover");
    crossover.setParameter("probability",0.9);                   
    crossover.setParameter("distributionIndex",20.0);//20
    
    mutation = EMMutationFactory.getMutationOperator("EMBitFlipMutation");                    
    mutation.setParameter("probability",1.0/problem.getNumberOfVariables());
    mutation.setParameter("distributionIndex",20.0);//20
        
    // Selection Operator 
    selection = SelectionFactory.getSelectionOperator("BinaryTournament") ;  
    
    // Add the operators to the algorithm
    algorithm.addOperator("crossover",crossover);
    algorithm.addOperator("mutation",mutation);
    algorithm.addOperator("selection",selection);
    
    long initTime = System.currentTimeMillis();
    SolutionSet population = algorithm.execute();
    long estimatedTime = System.currentTimeMillis() - initTime;

    // Result messages 
    logger_.info("Total execution time: "+estimatedTime + "ms");
    logger_.info("Objectives values have been writen to file FUN");
    population.printObjectivesToFile("FUN");
    logger_.info("Variables values have been writen to file VAR");
    population.printVariablesToFile("VAR");      
    
    if (indicators != null) {
      logger_.info("Quality indicators") ;
      logger_.info("Hypervolume: " + indicators.getHypervolume(population)) ;
      logger_.info("GD         : " + indicators.getGD(population)) ;
      logger_.info("IGD        : " + indicators.getIGD(population)) ;
      logger_.info("Spread     : " + indicators.getSpread(population)) ;
      logger_.info("Epsilon    : " + indicators.getEpsilon(population)) ;
    } // if                   
  }//main
} // MOCell_main
