/**
 * NSGAIIConv.java
 * 
 * Convergence check class for NSGAII.
 * Based on NSGAII from jMetal.
 * 
 * @author Juan J. Durillo
 * @author Mateusz Guzek
 * @version 1.0  
 */
package greenmetal.metaheuristics.nsgaII;

import greenmetal.experiments.ExperimentConvergence;
import greenmetal.metaheuristics.AlgorithmConvergence;

import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import jmetal.base.*;
//import jmetal.experiments.ExperimentConvergence;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.util.*;

/**
 * This class implements the NSGA-II algorithm. 
 */
public class NSGAIIConv extends Algorithm implements AlgorithmConvergence{

  /**
   * stores the problem  to solve
   */
  private Problem problem_;

  /**
   * Constructor
   * @param problem Problem to solve
   */
  public NSGAIIConv(Problem problem) {
    this.problem_ = problem;
  } // NSGAII

  public SolutionSet execute()
  {
	System.out.println("Error in NSGAIIConv: for the convergence study, the method execute with no parameters cannot be called");
	return null;
  }
  /**   
   * Runs the NSGA-II algorithm.
   * @return a <code>SolutionSet</code> that is a set of non dominated solutions
   * as a result of the algorithm execution
   * @throws JMException 
   */
  public SolutionSet execute(double [][][][][] metrics,int problemID, int inst, int alg,String[] indicatorList, String paretoFrontFile, String experimentDirectory) throws JMException, ClassNotFoundException {
    int populationSize;
    int maxEvaluations;
    int evaluations;

    QualityIndicator indicators = null; // QualityIndicator object
    int requiredEvaluations; // Use in the example of use of the
    // indicators object (see below)

    SolutionSet population;
    SolutionSet offspringPopulation;
    SolutionSet union;

    Operator mutationOperator;
    Operator crossoverOperator;
    Operator selectionOperator;

    Distance distance = new Distance();

    //Read the parameters
    populationSize = ((Integer) getInputParameter("populationSize")).intValue();
    maxEvaluations = ((Integer) getInputParameter("maxEvaluations")).intValue();
    //indicators = (QualityIndicator) getInputParameter("indicators");

    //Initialize the variables
    population = new SolutionSet(populationSize);
    evaluations = 0;

    requiredEvaluations = 0;

    //Read the operators
    mutationOperator = operators_.get("mutation");
    crossoverOperator = operators_.get("crossover");
    selectionOperator = operators_.get("selection");

    // Create the initial solutionSet
    Solution newSolution;
    for (int i = 0; i < populationSize; i++) {
      newSolution = new Solution(problem_);
      problem_.evaluate(newSolution);
      problem_.evaluateConstraints(newSolution);
      evaluations++;
      population.add(newSolution);
    } //for       
    
	if (indicatorList.length > 0) {
		// System.out.println("PF file: " +
		// paretoFrontFile_[problemId]);
		indicators = new QualityIndicator(problem_,
				paretoFrontFile);
	}
	int generations = 0;
    
    // Generations ...
    while (evaluations < maxEvaluations) {

      // Create the offSpring solutionSet      
      offspringPopulation = new SolutionSet(populationSize);
      Solution[] parents = new Solution[2];
      for (int i = 0; i < (populationSize / 2); i++) {
        if (evaluations < maxEvaluations) {
          //obtain parents
          parents[0] = (Solution) selectionOperator.execute(population);
          parents[1] = (Solution) selectionOperator.execute(population);
          Solution[] offSpring = (Solution[]) crossoverOperator.execute(parents);
          mutationOperator.execute(offSpring[0]);
          mutationOperator.execute(offSpring[1]);
          problem_.evaluate(offSpring[0]);
          problem_.evaluateConstraints(offSpring[0]);
          problem_.evaluate(offSpring[1]);
          problem_.evaluateConstraints(offSpring[1]);
          offspringPopulation.add(offSpring[0]);
          offspringPopulation.add(offSpring[1]);
          evaluations += 2;
        } // if                            
      } // for


      // Create the solutionSet union of solutionSet and offSpring
      union = ((SolutionSet) population).union(offspringPopulation);

      // Ranking the union
      Ranking ranking = new Ranking(union);

      int remain = populationSize;
      int index = 0;
      SolutionSet front = null;
      population.clear();

      // Obtain the next front
      front = ranking.getSubfront(index);

      while ((remain > 0) && (remain >= front.size())) {
        //Assign crowding distance to individuals
        distance.crowdingDistanceAssignment(front, problem_.getNumberOfObjectives());
        //Add the individuals of this front
        for (int k = 0; k < front.size(); k++) {
          population.add(front.get(k));
        } // for

        //Decrement remain
        remain = remain - front.size();

        //Obtain the next front
        index++;
        if (remain > 0) {
          front = ranking.getSubfront(index);
        } // if        
      } // while

      // Remain is less than front(index).size, insert only the best one
      if (remain > 0) {  // front contains individuals to insert                        
        distance.crowdingDistanceAssignment(front, problem_.getNumberOfObjectives());
        front.sort(new jmetal.base.operator.comparator.CrowdingComparator());
        for (int k = 0; k < remain; k++) {
          population.add(front.get(k));
        } // for

        remain = 0;
      } // if                               
      if (indicatorList.length > 0) {
//			QualityIndicator indicators;
//			// System.out.println("PF file: " +
//			// paretoFrontFile_[problemId]);
//			indicators = new QualityIndicator(problem_,
//					paretoFrontFile);

			for (int j = 0; j < indicatorList.length; j++) {
				if (indicatorList[j].equals("HV")) {
					double value = indicators.getHypervolume(ranking.getSubfront(0));
					metrics[problemID][inst][alg][j][generations] = value;
				}
				if (indicatorList[j].equals("SPREAD")) {
						double value = indicators.getSpread(ranking.getSubfront(0));
						metrics[problemID][inst][alg][j][generations] = value;
				}
				if (indicatorList[j].equals("IGD")) {
						double value = indicators.getIGD(ranking.getSubfront(0));
						metrics[problemID][inst][alg][j][generations] = value;
				}
				if (indicatorList[j].equals("EPSILON")) {
						double value = indicators.getEpsilon(ranking.getSubfront(0));
						metrics[problemID][inst][alg][j][generations] = value;
				}
			} // for
		} // if
  
  generations++;
      // This piece of code shows how to use the indicator object into the code
      // of NSGA-II. In particular, it finds the number of evaluations required
      // by the algorithm to obtain a Pareto front with a hypervolume higher
      // than the hypervolume of the true Pareto front.
//      if ((indicators != null) &&
//        (requiredEvaluations == 0)) {
//        double HV = indicators.getHypervolume(population);
//        if (HV >= (0.98 * indicators.getTrueParetoFrontHypervolume())) {
//          requiredEvaluations = evaluations;
//        } // if
//      } // if
    } // while
    
int maxgen = generations - 1;
	

	// Prints all the values in metrics in files
	if (indicatorList.length > 0) {

		for (int j = 0; j < indicatorList.length; j++) {
			if (indicatorList[j].equals("HV")) {
				FileWriter os;
				try {
					os = new FileWriter(experimentDirectory
							+ "/ConvHV", true);
					for (int gens = 0; gens < maxgen; gens++)
						os.write("" + metrics[problemID][inst][alg][j][gens] + " ");
					os.write("\n");
					os.close();
				} catch (IOException ex) {
					Logger.getLogger(
							ExperimentConvergence.class.getName())
							.log(Level.SEVERE, null, ex);
				}
			}
			if (indicatorList[j].equals("SPREAD")) {
				FileWriter os = null;
				try {
					
					os = new FileWriter(experimentDirectory
							+ "/ConvSPREAD", true);
					for (int gens = 0; gens < maxgen; gens++)
						os.write("" + metrics[problemID][inst][alg][j][gens] + " ");
					os.write("\n");
					os.close();
				} catch (IOException ex) {
					Logger.getLogger(
							ExperimentConvergence.class.getName())
							.log(Level.SEVERE, null, ex);
				} finally {
					try {
						os.close();
					} catch (IOException ex) {
						Logger.getLogger(
								ExperimentConvergence.class
								.getName()).log(
										Level.SEVERE, null, ex);
					}
				}
			}
			if (indicatorList[j].equals("IGD")) {
				FileWriter os = null;
				try {
					os = new FileWriter(experimentDirectory
							+ "/ConvIGD", true);
					for (int gens = 0; gens < maxgen; gens++)
						os.write("" + metrics[problemID][inst][alg][j][gens] + " ");
					os.write("\n");
					os.close();
				} catch (IOException ex) {
					Logger.getLogger(
							ExperimentConvergence.class.getName())
							.log(Level.SEVERE, null, ex);
				} finally {
					try {
						os.close();
					} catch (IOException ex) {
						Logger.getLogger(
								ExperimentConvergence.class
								.getName()).log(
										Level.SEVERE, null, ex);
					}
				}
			}
			if (indicatorList[j].equals("EPSILON")) {
				FileWriter os = null;
				try {
					os = new FileWriter(experimentDirectory
							+ "/ConvEPSILON", true);
					for (int gens = 0; gens < maxgen; gens++)
						os.write("" + metrics[problemID][inst][alg][j][gens] + " ");
					os.write("\n");
					os.close();
				} catch (IOException ex) {
					Logger.getLogger(
							ExperimentConvergence.class.getName())
							.log(Level.SEVERE, null, ex);
				} finally {
					try {
						os.close();
					} catch (IOException ex) {
						Logger.getLogger(
								ExperimentConvergence.class
								.getName()).log(
										Level.SEVERE, null, ex);
					}
				}
			}
		} // for
	}
    
    
    // Return as output parameter the required evaluations
    setOutputParameter("evaluations", requiredEvaluations);
    
    // Return the first non-dominated front
    Ranking ranking = new Ranking(population);
    return ranking.getSubfront(0);
  } // execute
} // NSGA-II
