package greenmetal.problems;
/**
 * EMProblemFactory.java
 * 
 * ProblemFactory adapted to include EMscheduling problem.
 * Based on ProblemFactory from jMetal.
 * 
 * @author Juan J. Durillo
 * @author Mateusz Guzek
 * @version 1.0
 */


import greenmetal.problems.EMscheduling.EMscheduling;

import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.logging.Logger;
import jmetal.base.Problem;
import jmetal.util.Configuration;
import jmetal.util.JMException;

/**
 * This class represents a factory for problems
 */
public class EMProblemFactory {
  /**
   * Creates an object representing a problem
   * @param name Name of the problem
   * @param params Parameters characterizing the problem
   * @return The object representing the problem
   * @throws JMException 
   */
  public Problem getProblem(String name, Object [] params) throws JMException {
    // Params are the arguments
    // The number of argument must correspond with the problem constructor params
    System.out.println("Problem:"+name);
    String base = "greenmetal.problems.EMscheduling.EMscheduling"; //EMscheduling.";
//    if (name.substring(0,name.length()-1).equalsIgnoreCase("DTLZ"))
//      base += "DTLZ.";
//    else if (name.substring(0,name.length()-1).equalsIgnoreCase("WFG"))
//      base += "WFG.";
//    else if (name.substring(0,name.length()-1).equalsIgnoreCase("ZDT"))
//      base += "ZDT.";    
//    else if (name.substring(0,name.length()-3).equalsIgnoreCase("ZZJ07"))
//      base += "ZZJ07.";        
//    else if (name.substring(0,name.length()-3).equalsIgnoreCase("LZ09"))
//      base += "LZ09.";        
//    else if (name.substring(0,name.length()-4).equalsIgnoreCase("ZZJ07"))
//        base += "ZZJ07.";    
//    else if (name.substring(0,name.length()-3).equalsIgnoreCase("LZ06"))
//      base += "LZ06.";    
//    else if (name.substring(0,name.length()-4).equalsIgnoreCase("CEC2009"))
//      base += "cec2009Competition.";    
//    else if (name.substring(0,name.length()-5).equalsIgnoreCase("CEC2009"))

//      base += "cec2009Competition.";    
    String par0;
    String par1;
    boolean par2;
    Logger par3;
    boolean par4;
    Problem problem;
    try {
////    	Class test = Class.forName("java.lang.instrument.IllegalClassFormatException");
////    	System.out.println("Test class:" + test.getCanonicalName());
//    	//String name = "EMscheduling";
//    	Class problemClass;
//    	//if(name == "EMScheduling"){
//    		problemClass = Class.forName(base/*+name*/);
////    		}
//    	//else{
////    		problemClass = Class.forName(base+"EMScheduling");
//    	//}
////      System.out.println("Problem class:" + problemClass.getCanonicalName());
//      Constructor [] constructors = problemClass.getConstructors();
////      System.out.println("This class has"+ constructors.length+"constructors");
////      System.out.println("Constructor l ="+constructors[0].getParameterTypes().length+ "and params l = "+params.length);
//      int i = 0;
//      //find the constructor
//      while ((i < constructors.length) && 
//             (constructors[i].getParameterTypes().length!=params.length)) {
//        i++;
//      }
//      // constructors[i] is the selected one constructor
//      Problem problem = (Problem)constructors[i].newInstance(params);
     par0=(String)params[0];
     par1=(String)params[1];
     par2=(Boolean)params[2];
     par3=(Logger)params[3];
     par4=(Boolean)params[4];
    	
     
    }// try
    catch(Exception e) {
      Configuration.logger_.severe( "EMProblemFactory.getProblem: " +e.getClass()+
          "Problem '"+ base/*+name*/ + "' does not exist. "  +
          "Please, check the problem names in greenmetal/problems") ;
      Configuration.logger_.severe("Cause:"+ e.getCause() ) ;
      Configuration.logger_.severe("Exception:\n"+ e) ;
      System.err.println("Passed parameters:");
      for(int k = 0; k < params.length; k++){
      	System.err.println(params[k]);
      }
      e.printStackTrace();
      throw new JMException("Exception in " + "EMProblemFactory" + ".getProblem()");
    } // catch   
    
	try {
		problem = greenmetal.problems.EMscheduling.EMscheduling.getInstance(par0,par1,par2,par3,par4);
		return problem;
	} catch (ClassNotFoundException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		throw new JMException("Exception in " + "EMProblemFactory" + ".getProblem()");
	}
     
  }    
  
//  /*Not supported in greenmtal*/
//  public Problem getProblem(String name, Properties params) throws JMException {
//    // Params are the arguments
//    // The number of argument must correspond with the problem constructor params
//
//    String base = "jmetal.gui.problems.";
//    if (name.substring(0,name.length()-1).startsWith("DTLZ"))
//      base += "DTLZ.";
//    else if (name.substring(0,name.length()-1).startsWith("WFG"))
//      base += "WFG.";
//    else if (name.substring(0,name.length()-1).startsWith("ZDT"))
//      base += "ZDT.";
//    else if (name.substring(0,name.length()-3).startsWith("ZZJ07"))
//      base += "ZZJ07.";
//    else if (name.substring(0,name.length()-3).startsWith("LZ09"))
//      base += "LZ09.";
//    else if (name.substring(0,name.length()-4).startsWith("ZZJ07"))
//        base += "ZZJ07.";
//    else if (name.substring(0,name.length()-3).startsWith("LZ06"))
//      base += "LZ06.";
//    else if (name.substring(0,name.length()-4).startsWith("CEC2009"))
//      base += "cec2009Competition.";
//    else if (name.substring(0,name.length()-5).startsWith("CEC2009"))
//      base += "cec2009Competition.";
//
//    try {
//      Class problemClass = Class.forName(base+name);
//      //Constructor constructors = problemClass.getConstructor(Properties.class);
//      Constructor constructors = problemClass.getConstructor(Properties.class);
//
//      Problem problem = (Problem)constructors.newInstance(params);
//     
//      return problem;
//    }// try
//    catch(Exception e) {
//        e.printStackTrace();
//      Configuration.logger_.severe("ProblemFactory.getProblem: " +
//          "Problem '"+ name + "' does not exist. "  +
//          "Please, check the problem names in jmetal/problems") ;
//      throw new JMException("Exception in " + name + ".getProblem()") ;
//    } // catch
//  }

}
