package greenmetal.problems.EMscheduling;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;


/**
 * DagFileReader.java
 * 
 * Object which reads DAG file with .dag format. It stores the DAG file name. The result of reading is
 * a Graphe object.
 *
 * @author Mateusz Guzek
 * @version 1.0
 */
public class DagFileReader {
	private String fileName;
	private Logger logger_;
	private int maxClusters;
	public static final int START = 0;
	public static final int READTASK1 = 1;
	public static final int READEDGESTART1= 2;
	public static final int READEDGEEND =3;
	public static final int READEDGECOST =4;
	public static final int READHEADER =5;
	public static final int READTASK2= 6;
	public static final int READEDGESTART2= 7;
	public static final int READOPTIMAL= 8;
	public static final int READCRITICAL= 9;
	
	public static final boolean debugLocal = false;
	/**
	 * 
	 * @param fileName Name of the DAG file
	 * @param logger_
	 *
	 */
	public DagFileReader(String fileName, Logger logger_) {
		super();
		this.fileName = fileName;
		this.logger_ = logger_;	
		
		}
	/**
	 * Method which import DAG from a standard file.
	 * 
	 * @return Graphe which represents DAG from read file.
	 */
	public Graphe readFile(){
		File f;
		char c = 0;
		char buffer[];
		buffer = new char[255];
		int taskIndex = 0;
		int edgeIndex = 0;
		double cost = 0;
		ArrayList<Double> runTime = null;
		ArrayList<Task> tmpTaskTable = new ArrayList<Task>();
		ArrayList<Edge> tmpEdgeTable = new ArrayList<Edge>();
		Task task1 = null, task2 = null;
		int state=START;
		int i=0,j=0;
		boolean exit=false;
		f = new File(fileName);
		FileReader fr = null;
		try {
			fr = new FileReader(f);
		} catch (FileNotFoundException e) {
			logger_.info("File not found, fileName:"+fileName);
			e.printStackTrace();
			return null;
		}
		Graphe DAG = new Graphe(maxClusters);
		try{
		try {

			while(c != (char)-1){

				c = (char)fr.read();
				if ( (!isspace(c)) || (c=='\n') ){
					switch(state){
					case START:
						if (c=='#'){
							state = READHEADER;
							i = 0;
						}
						break;
					case READHEADER:
						if (c=='\n'){
							buffer[i] = '\0';
							if (new String(buffer).startsWith("tasks")){
								state = READTASK1;
							} else if (new String(buffer).startsWith("edges")){
								state = READEDGESTART1;
							} else if (new String(buffer).startsWith("optimal")){
								state = READOPTIMAL;
							} else if (new String(buffer).startsWith("critical")){
								state = READCRITICAL;
							} else if (new String(buffer).startsWith("end")){
								exit = true;
							} else {
								logger_.info("setupDAG:"+ "Error reading in DAG file");
							}
							buffer = new char[255];
							i = 0;
						} else {
							buffer[i] = c;
							i++;
							if(debugLocal)System.out.println(new String(buffer));
						}
						break;
					case READOPTIMAL:
						if (c=='\n'){
							buffer[i] = '\0';
							cost = Double.parseDouble(new String(buffer));
							DAG.setOptimal(cost);
							state = START;
							i = 0;
							buffer = new char[255];
						} else {
							buffer[i] = c;
							i++;
						}
						break;
					case READCRITICAL:
						if(debugLocal)System.out.println(new String(buffer));
						if (c=='\n'){
							buffer[i] = '\0';
							cost = Double.parseDouble(new String(buffer));
							DAG.setCritical(cost);
							state = START;
							i = 0;
							buffer = new char[255];
						} else {
							buffer[i] = c;
							i++;
						}
						break;
					case READTASK1:
						if (c==':'){
							state = READTASK2;
						} else if (c=='#'){
							state = READHEADER;
						}
						runTime = new ArrayList<Double>();
						i = 0;
						buffer = new char[255];
						break;
					case READTASK2:
						if (c==','){
							cost = Double.parseDouble(new String(buffer));
							runTime.add(cost);
							state = READTASK2;
							buffer = new char[255];
							if(debugLocal)System.out.print(cost+", ");
							i=0;
							j++;
							
						}else
							if (c=='\n'){
								cost = Double.parseDouble(new String(buffer));
								runTime.add(cost);
								tmpTaskTable.add(new Task(runTime,taskIndex));
								taskIndex++;
								state = READTASK1;
								if(debugLocal)System.out.println(cost);
								i = 0;
								j=0;
								buffer = new char[255];
							} else {
								buffer[i] = c;
								i++;
							}
						break;
					case READEDGESTART1:
						if (c==':'){
							state = READEDGESTART2;
						} else if (c=='#'){
							state = READHEADER;
						}
						i = 0;
						buffer = new char[255];
						break;
					case READEDGESTART2:
						if (c==','){
							task1 = tmpTaskTable.get(Integer.parseInt(new String(buffer).trim()));
							if(debugLocal)System.out.print(": " + new String(buffer).trim());
							state = READEDGEEND;
							i = 0;
							buffer = new char[255];
							
						} else {
							buffer[i] = c;
							i++;	
						}
						break;
					case READEDGEEND:
						if (c==','){
							task2 =  tmpTaskTable.get(Integer.parseInt(new String(buffer).trim()));
							if(debugLocal)System.out.print(", " + new String(buffer).trim());
							state = READEDGECOST;
							i = 0;
							buffer = new char[255];
						} else {
							buffer[i] = c;
							i++;
							
						}
						break;
					case READEDGECOST:
						if (c=='\n'){
							cost = Double.parseDouble(new String(buffer));
							if(task1 !=null && task2 !=null){
								
							tmpEdgeTable.add(new Edge(task1, task2, cost,edgeIndex));
							edgeIndex++;
							if(debugLocal)System.out.println(", " + cost);
							} else {
								logger_.info("Error: attempt to create an edge with null ptr on one of its ends.");
								break;		
							}
							state = READEDGESTART1;
							i = 0;
							buffer = new char[255];
						} else {
							buffer[i] = c;
							i++;
						}
						break;
					}
					if (exit) break;
				}

			}
			}catch (IOException e) {
				logger_.info("Problem with DAG file reading.");
				logger_.severe("Problem with DAG file reading.\n"+ e.getClass() +"\n" + e.getMessage());
				e.printStackTrace();
				//return 
			}
			DAG.setTaskTable(tmpTaskTable.toArray(new Task[tmpTaskTable.size()]));
			DAG.setEdgeTable(tmpEdgeTable.toArray(new Edge[tmpEdgeTable.size()]));
			DAG.setMaxClusters(DAG.getTask(0).getRunTimeLength());
			DAG.makeTasksReadyToUse();
			if(debugLocal)System.out.print(DAG);
			try {
				fr.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	} catch(Exception e){
		logger_.severe("Unresolved problem with DAG file reading.\n"+ e.getClass() +"\n" + e.getMessage());
		logger_.severe("Trying one more time");
		return new DagFileReader(fileName, logger_).readFile();
	}
			return DAG;
		}
		boolean isspace(char c){
			if(c == ' ')
				return true;
			else return false;
		}



	}
