package greenmetal.problems.EMscheduling;

import java.util.logging.Logger;

import jmetal.base.Problem;
import jmetal.base.Solution;
import jmetal.base.solutionType.IntSolutionType;
import jmetal.util.JMException;
/**
 * EMscheduling.java
 * 
 * Energy aware Multiobjective task scheduling problem
 * Ideas for further development:
 * 1. Check ensuring good distribution of solution mechanism
 * 2. Possible constraints adding
 * 
 * @author Mateusz Guzek
 * @version 1.0
 */


public class EMscheduling extends Problem {


	private static final long serialVersionUID = -5603206910830625205L;
	private static boolean initialized = false;
	private static EMscheduling singleton = null;
	protected  boolean test_evaluation;
	private static final boolean reclamation = true;
	protected boolean debug = false;
	protected static final int numberOfObjectivesByDefault_ =   2 ;
	protected        int       numberOfMachines_            =   0 ;
	protected        int       numberOfTasks_               =   0 ;
	protected		 int	   numberOfVoltages_				=	1;
	protected		String		instanceFileName;
	protected		Graphe		DAG;
	protected		EstScheduler localScheduler;
	protected		Logger		logger_;
	protected		PairVLSSpeed[][] processorPairs;
	public EMscheduling(){
		super();
	}
	private EMscheduling(String instanceFileName, String processorsFileName, boolean reclaim ,Logger logger_,boolean test_evaluation) throws ClassNotFoundException{
		super();
		
		


		/*General settings*/
		this.test_evaluation = test_evaluation;
		solutionType_ = new IntSolutionType(this);
		numberOfObjectives_ = 2;

		/*Setting file name and logger.*/
		this.instanceFileName =  instanceFileName;
		System.out.println(instanceFileName);
		this.logger_ = logger_;
		/*DAG loading*/
		DAG = new DagFileReader(instanceFileName, logger_).readFile();
		/*Setting priorities.*/
		DAG.setPriorities();

		ProcFileReader pfr = new ProcFileReader(processorsFileName, logger_, DAG.getMaxClusters());
		processorPairs = pfr.readFile();

		if(debug)
			{printProcessors();}

		/*Creation of scheduler for evaluation. b_level calculated inside.*/
		localScheduler = new EstScheduler(DAG,processorPairs,reclamation, logger_,test_evaluation);
		/*First print of DAG.*/
		if(debug){
		System.out.print(DAG);
		}
		/*Setting optimization parameters based on DAG characteristics.*/
		numberOfMachines_ = DAG.getMaxClusters();
		numberOfTasks_ = DAG.getTaskNumber();
		numberOfVariables_ = numberOfTasks_ * 2;
		/*Print.*/
		if(debug){
		System.out.println("Number of machines:" + numberOfMachines_+"\n"+
				"Number of tasks:"+ numberOfTasks_);
		System.out.println("Used vls levels:\n"+localScheduler.getStringPairsVLSSpeed());}
		/*Setting variables limits.*/
		upperLimit_ = new double[numberOfVariables_];
		lowerLimit_ = new double[numberOfVariables_];
		for (int var = 0; var < numberOfTasks_; var++){
			lowerLimit_[var] = 0;
			upperLimit_[var] = numberOfMachines_-1;
		}
		for (int var = numberOfTasks_; var < numberOfVariables_-1; var++){
			lowerLimit_[var] = 0;
			upperLimit_[var] = numberOfVoltages_-1;
		}
	}
	
	public static EMscheduling getInstance(String instanceFileName, String processorsFileName, boolean reclaim ,Logger logger_,boolean test_evaluation) throws ClassNotFoundException{
		if(!initialized){
			singleton  = new EMscheduling(instanceFileName, processorsFileName, reclaim, logger_, test_evaluation);
			initialized = true;
			return singleton;
		} else {
			return singleton;
		}
	}
	public static void destroyInstance(){
		if(initialized==true)
		{
			singleton=null;
			initialized=false;
		}
	}

	private void printProcessors() {
		for(int i = 0; i < processorPairs.length; i++){
			System.out.println("P:"+i);
			for(int j=0; j <processorPairs[i].length; j++ ){
				System.out.println(processorPairs[i][j]);
			}

		}
	}

	public Problem initializeEMProblem(String[] args,boolean reclaim, Logger logger_,boolean test_evaluation) throws ClassNotFoundException{
		Problem problem;
		if (args.length >= 2) {
			problem = new EMscheduling(args[0],args[1],reclaim,logger_,test_evaluation);
		} else if(args.length == 1){
			problem = new EMscheduling(args[0],"file_proc",reclaim,logger_,test_evaluation);
		}    // if
		else {
			logger_.info("No instance file given as parameter.");
			problem = null;
		} // if
		return problem;
	}

	/**
	 * Evaluation method uses localScheduler, which calculates both
	 * makespan and energy of a solution.
	 */
	@Override
	public void evaluate(Solution solution) throws JMException {
		// TODO Auto-generated method stub


		double[] objectives = localScheduler.evaluateSolution(solution);

		solution.setObjective(0, objectives[0]);
		solution.setObjective(1, objectives[1]);
		//CHANGE
		
		//		for(int i = 0; i < solution.numberOfVariables(); i++){
		//			System.out.print((int)(solution.getDecisionVariables()[i].getValue())+" ");
		//		}
		//System.out.format("Obj:\t%.2f\t%.2f\n", solution.getObjective(0),solution.getObjective(1));
	}
	public EstScheduler getLocalScheduler() {
		return localScheduler;
	}

}
