package greenmetal.problems.EMscheduling;
/**
 * Edge.java
 * 
 * Representation of an edge with references to task which itself connects.
 * 
 * @author Mateusz Guzek
 * @version 1.0
 */
public class Edge {
	private int index;
	private Task startTask;
	private Task endTask;
	private double commTime;

	
	
	public Edge(Task startTask, Task endTask, double commTime, int index) {
		super();
		this.startTask = startTask;
		this.endTask = endTask;
		this.commTime = commTime;
		this.index = index;
	}


	public Edge(Task startTask, Task endTask, double commTime) {
		super();
		this.startTask = startTask;
		this.endTask = endTask;
		this.commTime = commTime;	
	}


	Task getStartTask() {
		return startTask;
	}


	void setStartTask(Task startTask) {
		this.startTask = startTask;
	}


	Task getEndTask() {
		return endTask;
	}


	void setEndTask(Task endTask) {
		this.endTask = endTask;
	}


	double getCommTime() {
		return commTime;
	}


	void setCommTime(double commTime) {
		this.commTime = commTime;
	}


	int getIndex() {
		return index;
	}


	void setIndex(int index) {
		this.index = index;
	}
	public String toString(){
		return index + ":" + startTask.getIndex()+"->"+endTask.getIndex()+"\t"
		+ commTime;
	}
	
	
}
