package greenmetal.problems.EMscheduling;
/**
 * Graphe.java
 * 
 * Objects of this class store a full information about a graph, storing Task and Edge arrays.
 *
 * @author Mateusz Guzek
 * @version 1.0
 */
public class Graphe {
	private Task[] taskTable;
	private Edge[] edgeTable;
	private double optimal;
	private double critical;
	private int maxClusters;
	double vls_proc[]={1.75, 1.40, 1.20, 0.90};
	double rSpeed[]={1, 0.8, 0.60, 0.40};
//	double processors[][]=	{1.75, 1.40, 1.20, 0.90, 0, 0, 0},
//			{1, 0.8, 0.60, 0.40, 0, 0, 0},
//			
//			{1.5, 1.40, 1.3, 1.2, 1.1, 1.0, 0.90},
//			{1, 0.90, 0.80, 0.70, 0.60, 0.50, 0.40},
//			
//			{2.20, 1.90, 1.60, 1.30, 1.00,0,0},
//				{1, 0.85, 0.65, 0.50, 0.35,0,0},
//			
//			{1.50, 1.20, 0.90,0,0,0,0},
//			{1, 0.8, 0.50,0,0,0,0};
	
	
	public Graphe(int maxClusters) {
		super();
		this.maxClusters = maxClusters;
	}
	double getCritical() {
		return critical;
	}
	void setCritical(double critical) {
		this.critical = critical;
	}
	double getOptimal() {
		return optimal;
	}
	void setOptimal(double optimal) {
		this.optimal = optimal;
	}
	public int getTaskNumber(){
		return taskTable.length;
	}
	public int getEdgeNumber(){
		return edgeTable.length;
	}
	void setTaskTable(Task[] taskTable) {
		this.taskTable = taskTable;
	}
	void setEdgeTable(Edge[] edgeTable) {
		this.edgeTable = edgeTable;
	}
	void makeTasksReadyToUse(){
		
		for(int i = 0; i < edgeTable.length; i++){
			Edge tmpEdge = edgeTable[i];
			tmpEdge.getStartTask().addTmpOutEdge(tmpEdge);
			tmpEdge.getEndTask().addTmpInEdge(tmpEdge);
		}
		for(int i = 0; i < taskTable.length; i++){
			taskTable[i].makeReadyToUse();
		}
		
	}
	public Task getTask(int index){
		return taskTable[index];
	}
	public Edge getEdge(int index){
		return edgeTable[index];
	}
	public String toString(){
		String result ="";
		for(int i = 0; i < taskTable.length; i++){
			result += taskTable[i].toString()+"\n";
		}
		for(int i = 0; i < edgeTable.length; i++){
			result += edgeTable[i].toString()+"\n";
		}
		return result;
		
	}
	int getMaxClusters() {
		return maxClusters;
	}
	void setMaxClusters(int maxClusters) {
		this.maxClusters = maxClusters;
	}
	
	void setPriorities(){
		Task curTask;
		int i;

		for (i=0; i<this.getTaskNumber(); i++){
			curTask = this.getTask(i);
			if (curTask!=null){
				if (curTask.getNumOutEdges()==0){
					curTask.setPriority(1);
					curTask.setNextPriority();
				}
			}
		}
	}
	Task[] getTaskTableCopy(){	
		return taskTable.clone();
	}
	void resetAllTasks(){
		for(int i = 0; i < taskTable.length; i++){
			taskTable[i].setTmpScheduledTask(null);
		}
	}
	
}
