package greenmetal.problems.EMscheduling;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/**
 * ProcFileReader.java
 * 
 * Class used to read file with processors characteristics in format:
 * Number of processors with following characteristics
 * Voltage levels (separeted by one white space)
 * Relative speeds (separeted by one white space)
 * It is possible to put many characteristics possible in one file. Write them one directly below another. \
 * Example of file in code.
 * Example of file (without single space and star (comment) if you see them):
 *1
 *1.75 1.40 1.20 0.90
 *1 0.8 0.60 0.40
 *4
 *1.95 1.60 1.30 0.90
 *1 0.9 0.60 0.40
 * @author Mateusz Guzek
 * @version 1.0
 */
public class ProcFileReader {

	private String fileName;
	private Logger logger_;
	private int processors;
	public static boolean debugLocal = false;
	
	public ProcFileReader(String fileName, Logger logger_,int processors) {
		super();
		this.fileName = fileName;
		this.logger_ = logger_;
		this.processors = processors;
		
		}
	
	public PairVLSSpeed[][] readFile(){
		PairVLSSpeed[][] result = new PairVLSSpeed[processors][];
		File f = new File(fileName);
		FileReader fr = null;
		try {
			fr = new FileReader(f);
			System.out.println("Processors specification in file:"+fileName);
		} catch (FileNotFoundException e) {
			logger_.info("File not found, fileName:"+fileName);
			e.printStackTrace();
			return null;
		}
		BufferedReader br = new BufferedReader(fr);
		boolean run = true;
		String tmpStr;
		int tmpAmount;
		int j=0;

		while(run){
			try {
				tmpStr = br.readLine();
				if(tmpStr == null){
					logger_.info("Too few processors in file:" + fileName);
					break;
				}
				tmpAmount = Integer.parseInt(tmpStr);
				tmpStr = br.readLine();
				if(tmpStr == null){
					logger_.info("Unexpected end of file:" + fileName);
					break;
				}
				String[] strVol = tmpStr.split(" ");
				tmpStr = br.readLine();
				if(tmpStr == null){
					logger_.info("Unexpected end of file:" + fileName);
					break;
				}
				String[] strRsp = tmpStr.split(" ");
				if(strRsp.length != strVol.length){
					logger_.info("Corrupted file:" + fileName);
				}
				
				PairVLSSpeed[] tmpPairs = new PairVLSSpeed[strVol.length];
				for(int i = 0; i < tmpPairs.length; i++){
//					System.out.println("i="+i);
//					double tmp = Double.parseDouble(strVol[i]);
					tmpPairs[i]=new PairVLSSpeed(Double.parseDouble(strVol[i]), Double.parseDouble(strRsp[i]));
//					tmpPairs[i].setVls_proc(tmp);
//					tmpPairs[i].setrSpeed(Double.parseDouble(strRsp[i]));
				}
				for(int i = 0; i < tmpAmount;i++,j++){
					if(j==processors){
						//logger_.info("Too many processors,(more than"+processors+"), additional are neglected:" 
						//		+fileName);
						run = false;
						break;
					}
					result[j]=tmpPairs;
				}
				if(j==processors){
					run = false;
				}
				
//				for(int i = 0 ; i < tmpAmount && j < processors;i++,j++){
//					
//				}
				
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		try {
			fr.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		ArrayList<PairVLSSpeed> currentProc = new ArrayList<PairVLSSpeed>();
		return result;
		
	}
}
