package greenmetal.problems.EMscheduling;
/**
 * ScheduledTask.java
 * 
 * Object which represents position of a task in a schedule. In opposition to class Task,
 * objects of this class are used temporary, to calculate schedule length (makespan) and energy
 * consumption.
 * 
 * @author Mateusz Guzek
 * @version 1.0
 */
public class ScheduledTask {
	private Task task;
	private double startTime;
	private double proccesingTime;
	private double endTime;
	/**
	 * slack is defined as: time period between AST (actual start time, as in generated feasible schedule)
	 *  and LFT (latest finish time, which will not affect the makespan)
	 *  */
	private double slack; 
	private PairVLSSpeed vlsSettings;
	private int usedProcessor;
	private int positionInProcessor;
	
	public ScheduledTask(int usedProcessor, Task task, PairVLSSpeed vlsSettings) {
		super();
		this.usedProcessor = usedProcessor;
		this.task = task;
		this.vlsSettings = vlsSettings;
		this.proccesingTime = task.getRunTime(usedProcessor)/vlsSettings.getrSpeed();
		this.endTime = this.startTime + this.proccesingTime;
		this.task.setTmpScheduledTask(this);
	}
	Task getTask() {
		return task;
	}
	double getStartTime() {
		return startTime;
	}
	double getEndTime(){
		return endTime;
	}
	void setStartTime(double startTime) {
		this.startTime = startTime;
		this.endTime = startTime + proccesingTime;
	}
	double getProccesingTime() {
		return proccesingTime;
	}
	

	int getUsedProcessor() {
		return usedProcessor;
	}
	PairVLSSpeed getVlsSettings() {
		return vlsSettings;
	}
	
	public String toString(){
		String result = "";
		result += "proc:" + usedProcessor + " task:"+ task;
		result += " vls:"+ vlsSettings+ " procTime:"+ proccesingTime;
		return result;
	}
	public double getComputationEnergy(){
		//return task.getRunTime(usedProcessor)
		return this.proccesingTime
		*vlsSettings.getrSpeed()
		*vlsSettings.getVls_proc()
		*vlsSettings.getVls_proc();
	}
	public static double getEnergy(double time, PairVLSSpeed vlsSettings){
		return time 
		*vlsSettings.getrSpeed()
		*vlsSettings.getVls_proc()
		*vlsSettings.getVls_proc();
	}
	public double getSlack() {
		return slack;
	}
	public void setSlack(double slack) {
		this.slack = slack;
	}
	public int getPositionInProcessor() {
		return positionInProcessor;
	}
	public void setPositionInProcessor(int positionInProcessor) {
		this.positionInProcessor = positionInProcessor;
	}
	public double getBaseExecutionTime(){
		return proccesingTime * vlsSettings.getrSpeed();
	}
	
	
	
}
