package greenmetal.problems.EMscheduling;

import java.util.ArrayList;
import java.util.List;
/**
 * Task.java
 * 
 * Object representing a task.
 * Contains the whole information, which can be read from a file or inferred from 
 * the read information. Because of that, it does not change after creation (reading a file)
 * and initialization (calculation of b_level). However, the back reference to ScheduledTask
 * used in calcualtion of a schedule is changed during every evaluation.
 * 
 * @author Mateusz Guzek
 * @version 1.0
 */
public class Task {
	/**
	 * Global task index as in DAG file.
	 */
	private int index;
	/**
	 * Table with run times on processors.
	 */
	private Double[] runTime;
	/**
	 * Average of runTime values.
	 */
	private double avgRunTime;
	/**
	 * Bottom level of the task.
	 */
	private double b_level;
	/**
	 *  Temporary list of edges from predecessors - used for easy creation.
	 */
	private List<Edge> tmpInEdges;
	/**
	 * Temporary list of edges to succesors - - used for easy creation.
	 */
	private List<Edge> tmpOutEdges;
	/**
	 * Final list of edges from predecessors - used for fast access.
	 */
	private Edge[] inEdges;
	/**
	 * Final list of edges from succesors - used for fast access.
	 */
	private Edge[] outEdges;
	/**
	 * Task priority. It is NOT used in EMscheduling algorithm.
	 */
	private int priority;
	/**
	 * temporary assignement to ScheduledTask, used by evaluation,
	 * valid only during one schedule calculation.
	 */
	private ScheduledTask tmpScheduledTask;
	/*
	public Task(ArrayList<Double> runTime2) {
		super();
		this.runTime = (Double[])runTime2.toArray(new Double[1]);
		this.tmpInEdges = new ArrayList<Edge>();
		this.tmpOutEdges = new ArrayList<Edge>();
		for(int i = 0; i < runTime.length; i++){
			avgRunTime+=runTime[i];
		}
		avgRunTime=avgRunTime/runTime.length;
	}*/
	public Task(ArrayList<Double> runTime2, int index) {
		super();
		this.index = index;
		this.runTime = (Double[])runTime2.toArray(new Double[1]);
		this.tmpInEdges = new ArrayList<Edge>();
		this.tmpOutEdges = new ArrayList<Edge>();
		for(int i = 0; i < runTime.length; i++){
			avgRunTime+=runTime[i];
		}
		avgRunTime=avgRunTime/runTime.length;
	}

	void addTmpInEdge(Edge newEdge){
		tmpInEdges.add(newEdge);
	}

	void addTmpOutEdge(Edge newEdge){
		tmpOutEdges.add(newEdge);
	}

	void makeReadyToUse(){
		inEdges = tmpInEdges.toArray(new Edge[tmpInEdges.size()]);
		outEdges= tmpOutEdges.toArray(new Edge[tmpOutEdges.size()]);
		tmpInEdges=null;
		tmpOutEdges=null;
	}

	Double getRunTime(int index) {
		return runTime[index];
	}
	
	int getIndex() {
		return index;
	}
	void setIndex(int index) {
		this.index = index;
	}
	
	double getB_level() {
		return b_level;
	}

	void setB_level(double bLevel) {
		b_level = bLevel;
	}

	Edge getInEdge(int index){
		return inEdges[index];
	}
	Edge getOutEdge(int index){
		return outEdges[index];
	}
	double getAvgRunTime() {
		return avgRunTime;
	}
	int getRunTimeLength(){
		return runTime.length;
	}
	int getNumOutEdges(){
		return outEdges.length;
	}
	int getNumInEdges(){
		return inEdges.length;
	}
	public String toString(){
		String result = index+":";
		for(int i = 0; i < runTime.length; i++){
			result += runTime[i]+",";
		}
		result += "priority:" + priority;
		result +=" avgRunTime:"+ avgRunTime;
		result +=" b_level:"+b_level;
		return result;
	}
	public String showEdges(){
		String result = "In edges:\n";
		for(int i = 0; i < inEdges.length; i++){
			result += inEdges[i].toString()+ "\n";
		}
		result += "Out edges:\n";
		for(int i = 0; i < outEdges.length; i++){
			result += outEdges[i].toString()+ "\n";
		}
		return result;
	}
	public String showTmpEdges(){
		String result = "In tmp edges:\n";
		for(int i = 0; i < tmpInEdges.size(); i++){
			result += tmpInEdges.get(i).toString()+ "\n";
		}
		result += "Out tmp edges:\n";
		for(int i = 0; i < tmpOutEdges.size(); i++){
			result += tmpOutEdges.get(i).toString()+ "\n";
		}
		return result;
	}
	
	
	int getPriority() {
		return priority;
	}
	void setPriority(int priority) {
		this.priority = priority;
	}
	void setNextPriority(){
		Task nextTask;
		Edge nextEdge;
		int tmpPriority, nextPriority;
		int i;

		if (this.getNumInEdges()!=0){
			for (i=0; i<this.getNumInEdges(); i++){
				nextEdge = this.getInEdge(i);
				if (nextEdge!=null){
					nextTask = nextEdge.getStartTask();
					tmpPriority = this.priority + 1;
					nextPriority = nextTask.getPriority();
					if (tmpPriority > nextPriority){
						nextTask.setPriority(tmpPriority);
						nextTask.setNextPriority();
					}
				}
			}
		}
	}
	ScheduledTask getTmpScheduledTask() {
		return tmpScheduledTask;
	}
	void setTmpScheduledTask(ScheduledTask tmpScheduledTask) {
		this.tmpScheduledTask = tmpScheduledTask;
	}
	
	
}
